/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class PlotPanel
extends JPanel
implements ActionListener {
    BodeNyquist theApp;
    JButton theButton;
    JCheckBox theCheck;
    JLabel numLabel;
    JTextField numField;
    JLabel denLabel;
    JTextField denField;
    JLabel startLabel;
    JTextField startField;
    JTextArea resultsArea;
    JComboBox decadesCombo;
    JComboBox unitsCombo;

    PlotPanel(BodeNyquist bodeNyquist) {
        this.theApp = bodeNyquist;
        this.setPreferredSize(new Dimension(725, 160));
        this.setLayout(new GridLayout(1, 2, 8, 8));
        this.setOpaque(false);
        this.theButton = new JButton("Plot Response");
        this.theButton.setOpaque(false);
        this.theButton.addActionListener(this);
        this.theCheck = new JCheckBox("Hide Phase", false);
        this.theCheck.setOpaque(false);
        this.theCheck.addActionListener(this);
        String[] stringArray = new String[]{"2 Decades", "3 Decades", "4 Decades"};
        this.decadesCombo = new JComboBox<String>(stringArray);
        this.decadesCombo.setOpaque(false);
        int n = 2;
        try {
            n = Integer.parseInt(this.theApp.decadesStr);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Couldn't parse number of decades: " + this.theApp.decadesStr);
            n = 2;
        }
        n = Math.min(n, 4);
        n = Math.max(n, 2);
        this.decadesCombo.setSelectedIndex(n - 2);
        this.decadesCombo.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.decadesCombo);
        jPanel.add(this.theButton);
        jPanel.add(this.theCheck);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new GridLayout(4, 1));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.add(jPanel2);
        jPanel2.add(jPanel);
        this.numField = new JTextField(this.theApp.numStr, 20);
        this.numLabel = new JLabel("Numerator", 0);
        this.numLabel.setOpaque(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.numField);
        jPanel3.add(this.numLabel);
        jPanel2.add(jPanel3);
        this.denField = new JTextField(this.theApp.denStr, 20);
        this.denLabel = new JLabel("Denominator", 0);
        this.denLabel.setOpaque(false);
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(this.denField);
        jPanel4.add(this.denLabel);
        jPanel2.add(jPanel4);
        this.startField = new JTextField(this.theApp.startStr, 12);
        this.startLabel = new JLabel("Start Freq.", 0);
        this.startLabel.setOpaque(false);
        String[] stringArray2 = new String[]{"rad/sec", "Hz"};
        this.unitsCombo = new JComboBox<String>(stringArray2);
        this.unitsCombo.setOpaque(false);
        if (null != this.theApp.unitsStr && this.theApp.unitsStr.equalsIgnoreCase("Hz")) {
            this.unitsCombo.setSelectedItem("Hz");
        } else {
            this.unitsCombo.setSelectedItem("rad/sec");
        }
        this.unitsCombo.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setOpaque(false);
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(this.unitsCombo);
        jPanel5.add(this.startField);
        jPanel5.add(this.startLabel);
        jPanel2.add(jPanel5);
        this.resultsArea = new JTextArea("Transfer function results appear here.");
        this.resultsArea.setEditable(false);
        this.resultsArea.setBorder(BorderFactory.createEtchedBorder());
        this.add(new JScrollPane(this.resultsArea));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.theCheck) {
            this.theApp.theCanvas.repaint();
            this.theApp.thePolar.repaint();
        } else {
            this.doPlot();
        }
    }

    void doPlot() {
        double d;
        double[] dArray;
        double[] dArray2;
        this.theApp.numStr = this.numField.getText();
        try {
            dArray2 = Polynomial.convertPolyList(this.theApp.numStr);
        }
        catch (NumberFormatException numberFormatException) {
            this.resultsArea.setText("Couldn't parse numerator: " + this.theApp.numStr);
            System.out.println("Couldn't parse numerator: " + this.theApp.numStr);
            return;
        }
        this.theApp.denStr = this.denField.getText();
        try {
            dArray = Polynomial.convertPolyList(this.theApp.denStr);
        }
        catch (NumberFormatException numberFormatException) {
            this.resultsArea.setText("Couldn't parse denominator: " + this.theApp.denStr);
            System.out.println("Couldn't parse denominator: " + this.theApp.denStr);
            return;
        }
        this.theApp.startStr = this.startField.getText();
        try {
            d = Double.parseDouble(this.theApp.startStr);
        }
        catch (NumberFormatException numberFormatException) {
            this.resultsArea.setText("Couldn't parse start freq: " + this.theApp.startStr);
            System.out.println("Couldn't parse start freq: " + this.theApp.startStr);
            return;
        }
        boolean bl = false;
        Object object = this.theApp.thePanel.unitsCombo.getSelectedItem();
        if ("Hz" == object) {
            bl = true;
        }
        System.out.print("  Numerator: ");
        Polynomial.showArray(dArray2);
        System.out.print("Denominator: ");
        Polynomial.showArray(dArray);
        System.out.println("Start freq.: " + d + ' ' + object);
        this.theApp.theData = new PlotData(this.theApp, d, bl, dArray2, dArray);
        StringBuffer stringBuffer = this.theApp.theData.getResult();
        if (null == stringBuffer) {
            System.out.println("Error: failed to plot data.");
            this.resultsArea.setText("Error: failed to plot data.");
            return;
        }
        this.resultsArea.setText(stringBuffer.toString());
        this.theApp.theCanvas.repaint();
        this.theApp.thePolar.repaint();
    }
}

