/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.text.DecimalFormat;

class PlotData {
    Complex[] theResult;
    double[] theFreqs;
    double maxReal;
    double minReal;
    double maxImag;
    double minImag;
    double startFreq;
    boolean unitsHz;
    int theRange;
    int numDecades;
    BodeNyquist theApp;

    PlotData(BodeNyquist bodeNyquist, double d, boolean bl, double[] dArray, double[] dArray2) {
        this.theApp = bodeNyquist;
        this.startFreq = d;
        this.unitsHz = bl;
        Object object = this.theApp.thePanel.decadesCombo.getSelectedItem();
        this.theRange = 300;
        if ("2 Decades" == object) {
            this.theRange = 300;
            this.numDecades = 2;
        } else if ("3 Decades" == object) {
            this.theRange = 200;
            this.numDecades = 3;
        } else if ("4 Decades" == object) {
            this.theRange = 150;
            this.numDecades = 4;
        }
        double d2 = 1.0;
        if (this.unitsHz) {
            d2 = Math.PI * 2;
        }
        int n = 0;
        this.theFreqs = new double[601];
        this.theFreqs[0] = this.startFreq * d2;
        n = 1;
        while (n < 601) {
            this.theFreqs[n] = Math.pow(10.0, 1.0 / (double)this.theRange) * this.theFreqs[n - 1];
            ++n;
        }
        this.plotAll(dArray, dArray2);
    }

    StringBuffer getResult() {
        int n = 0;
        StringBuffer stringBuffer = this.unitsHz ? new StringBuffer("Frequency(Hz)") : new StringBuffer("Frequency(r/s)");
        stringBuffer.append("\tComplex Response\n");
        DecimalFormat decimalFormat = new DecimalFormat("#.######E0");
        n = 0;
        while (n < this.theResult.length) {
            double d = this.theFreqs[n];
            if (this.unitsHz) {
                d /= Math.PI * 2;
            }
            stringBuffer.append(decimalFormat.format(d));
            stringBuffer.append('\t');
            stringBuffer.append(this.theResult[n].toString());
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer;
    }

    void paintPlot(Graphics graphics) {
        double d;
        int n;
        boolean bl = this.theApp.thePanel.theCheck.isSelected();
        graphics.translate(50, 3);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 599, 299);
        DecimalFormat decimalFormat = new DecimalFormat("#.####");
        int n2 = 0;
        int n3 = 0;
        n2 = 1;
        while (n2 < 10) {
            n3 = 0;
            while (n3 < this.numDecades) {
                n = (int)(Math.log(n2) * (double)this.theRange / Math.log(10.0) + 0.5 + (double)(n3 * this.theRange));
                d = (double)n2 * this.startFreq * Math.pow(10.0, n3);
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, 0, n, 299);
                graphics.setColor(Color.black);
                block0 : switch (this.numDecades) {
                    case 4: {
                        switch (n2) {
                            case 1: 
                            case 3: {
                                graphics.drawLine(n, 299, n, 304);
                                graphics.drawString(decimalFormat.format(d), n, 317);
                                break block0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (n2) {
                            case 1: 
                            case 2: 
                            case 5: {
                                graphics.drawLine(n, 299, n, 304);
                                graphics.drawString(decimalFormat.format(d), n, 317);
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (n2) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 6: {
                                graphics.drawLine(n, 299, n, 304);
                                graphics.drawString(decimalFormat.format(d), n, 317);
                                break block0;
                            }
                        }
                        break;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        graphics.drawLine(599, 299, 599, 304);
        d = this.startFreq * Math.pow(10.0, n3);
        graphics.drawString(decimalFormat.format(d), 599, 317);
        n2 = 1;
        while (n2 < 10) {
            graphics.setColor(Color.lightGray);
            n = n2 * 30;
            graphics.drawLine(0, n, 599, n);
            if (!bl) {
                graphics.setColor(Color.black);
                graphics.drawString(String.valueOf(225 - n2 * 45), 610, n + 4);
            }
            ++n2;
        }
        graphics.setColor(Color.black);
        if (this.unitsHz) {
            graphics.drawString("Freq.  (Hz)", 267, 290);
        } else {
            graphics.drawString("Freq.  (r/s)", 267, 290);
        }
        graphics.setColor(Color.blue);
        graphics.drawString("Gain (dB)", 10, 18);
        if (!bl) {
            graphics.setColor(Color.magenta);
            graphics.drawString("Phase (deg)", 520, 18);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, 599, 299);
        if (null == this.theResult || 0 == this.theResult.length) {
            System.out.println("Error: nothing to plot.");
            return;
        }
        double[] dArray = new double[this.theResult.length];
        double d2 = -100.0;
        n2 = 0;
        while (n2 < this.theResult.length) {
            double d3 = this.theResult[n2].mod();
            dArray[n2] = d3 = 20.0 * Math.log(d3) / Math.log(10.0);
            d2 = Math.max(d2, d3);
            ++n2;
        }
        d2 = Math.max(Math.min(d2, 90.0), -90.0);
        d2 = 6.0 * (double)Math.round(d2 / 6.0);
        n2 = 0;
        while (n2 < 9) {
            graphics.drawString(String.valueOf((int)(d2 - (double)n2 * 6.0)), -35, n2 * 30 + 34);
            ++n2;
        }
        graphics.clipRect(1, 1, 599, 299);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (!bl) {
            graphics.setColor(Color.magenta);
            n2 = 0;
            while (n2 < this.theResult.length) {
                n5 = (int)(150.5 - this.theResult[n2].arg() * 120.0 / Math.PI);
                if (0 == n2) {
                    n4 = n5;
                } else {
                    graphics.drawLine(n6, n4, n2, n5);
                }
                n4 = n5;
                n6 = n2++;
            }
        }
        n4 = 0;
        n5 = 0;
        n6 = 0;
        graphics.setColor(Color.blue);
        n2 = 0;
        while (n2 < this.theResult.length) {
            n5 = (int)(5.0 * (d2 - dArray[n2] + 6.0) + 0.5);
            if (0 == n2) {
                n4 = n5;
            } else {
                graphics.drawLine(n6, n4, n2, n5);
            }
            n4 = n5;
            n6 = n2++;
        }
    }

    void paintPolar(Graphics graphics) {
        String string;
        boolean bl = this.theApp.thePanel.theCheck.isSelected();
        graphics.translate(40, 3);
        double d = Math.max(this.maxReal, -this.minReal);
        double d2 = Math.max(this.maxImag, -this.minImag);
        double d3 = Math.max(0.5 * d, d2);
        d3 = Math.max(1.0E-6, d3);
        double d4 = Math.log(d3) / Math.log(10.0);
        d4 = Math.pow(10.0, Math.round(d4 - 1.5));
        d3 = d4 * (double)Math.round(d3 / d4);
        double d5 = 130.0 / d3;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 599, 299);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(0, 150, 604, 150);
        graphics.drawLine(300, 0, 300, 304);
        DecimalFormat decimalFormat = new DecimalFormat("#.######");
        int n = -10;
        while (n <= 10) {
            if (0 == n % 10) {
                graphics.setColor(Color.gray);
                graphics.drawLine(294, 150 + n * 13, 306, 150 + n * 13);
                graphics.setColor(Color.black);
                graphics.drawLine(600, 150 + n * 13, 604, 150 + n * 13);
                string = decimalFormat.format((double)n * d3 / 10.0);
                graphics.drawString(string, 610, 154 - n * 13);
            } else if (0 == n % 5) {
                graphics.setColor(Color.gray);
                graphics.drawLine(296, 150 + n * 13, 304, 150 + n * 13);
                graphics.drawLine(600, 150 + n * 13, 604, 150 + n * 13);
            } else {
                graphics.setColor(Color.lightGray);
                graphics.drawLine(298, 150 + n * 13, 302, 150 + n * 13);
            }
            ++n;
        }
        decimalFormat.applyPattern("#.######");
        n = -21;
        while (n <= 21) {
            graphics.setColor(Color.lightGray);
            if (0 == n % 10) {
                graphics.setColor(Color.gray);
                graphics.drawLine(300 + n * 13, 144, 300 + n * 13, 156);
                graphics.setColor(Color.black);
                graphics.drawLine(300 + n * 13, 300, 300 + n * 13, 304);
                string = decimalFormat.format((double)n * d3 / 10.0);
                graphics.drawString(string, 300 + n * 13, 317);
            } else if (0 == n % 5) {
                graphics.setColor(Color.gray);
                graphics.drawLine(300 + n * 13, 146, 300 + n * 13, 154);
            } else {
                graphics.setColor(Color.lightGray);
                graphics.drawLine(300 + n * 13, 148, 300 + n * 13, 152);
            }
            ++n;
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, 599, 299);
        graphics.drawString("Imaginary Plane", 256, 15);
        if (this.theResult == null || this.theResult.length == 0) {
            System.out.println("Error: nothing to plot.");
            return;
        }
        graphics.clipRect(1, 1, 598, 298);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (!bl) {
            int n6 = (int)(300.5 - d5);
            int n7 = (int)(2.0 * d5);
            graphics.setColor(Color.lightGray);
            graphics.drawOval(n6, n6 - 150, n7, n7);
            graphics.setColor(Color.magenta);
            n = 0;
            while (n < this.theResult.length) {
                n2 = (int)(300.5 + d5 * this.theResult[n].real());
                n3 = (int)(150.5 + d5 * this.theResult[n].imag());
                if (0 == n) {
                    n4 = n2;
                    n5 = n3;
                    graphics.drawLine(n6, 142, n6, 158);
                } else {
                    graphics.drawLine(n4, n5, n2, n3);
                }
                n4 = n2;
                n5 = n3;
                ++n;
            }
        }
        graphics.setColor(Color.black);
        n = 0;
        while (n < this.theResult.length) {
            n2 = (int)(300.5 + d5 * this.theResult[n].real());
            n3 = (int)(150.5 - d5 * this.theResult[n].imag());
            if (0 == n) {
                n4 = n2;
                n5 = n3;
                graphics.drawString("a", n2 - 12, n3 - 3);
                graphics.setColor(Color.blue);
            } else {
                graphics.drawLine(n4, n5, n2, n3);
            }
            n4 = n2;
            n5 = n3;
            ++n;
        }
        graphics.setColor(Color.black);
        graphics.drawString("z", n2 + 3, n3 - 3);
    }

    void plotAll(double[] dArray, double[] dArray2) {
        this.maxReal = -1.0E10;
        this.minReal = 1.0E10;
        this.maxImag = -1.0E10;
        this.minImag = 1.0E10;
        this.theResult = null;
        if (dArray.length == 0) {
            return;
        }
        if (dArray2.length == 0) {
            return;
        }
        if (this.theFreqs.length == 0) {
            return;
        }
        this.theResult = new Complex[this.theFreqs.length];
        int n = 0;
        n = 0;
        while (n < this.theFreqs.length) {
            Complex complex;
            Complex complex2 = new Complex(0.0, this.theFreqs[n]);
            Complex complex3 = new Complex(1.0, 0.0);
            Complex complex4 = new Complex(0.0, 0.0);
            int n2 = 0;
            n2 = 0;
            while (n2 < dArray.length) {
                complex = new Complex(dArray[n2], 0.0);
                complex.mpy(complex3);
                complex4.add(complex);
                complex3.mpy(complex2);
                ++n2;
            }
            complex3 = new Complex(1.0, 0.0);
            complex = new Complex(0.0, 0.0);
            n2 = 0;
            while (n2 < dArray2.length) {
                Complex complex5 = new Complex(dArray2[n2], 0.0);
                complex5.mpy(complex3);
                complex.add(complex5);
                complex3.mpy(complex2);
                ++n2;
            }
            this.theResult[n] = complex4.div(complex);
            double d = this.theResult[n].real();
            double d2 = this.theResult[n].imag();
            this.maxReal = Math.max(this.maxReal, d);
            this.minReal = Math.min(this.minReal, d);
            this.maxImag = Math.max(this.maxImag, d2);
            this.minImag = Math.min(this.minImag, d2);
            ++n;
        }
    }
}

