/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class BodeNyquist
extends JApplet {
    static final String versionStr = "Bode/Nyquist Plot Applet v. 2.0;  by M. Williamsen 8/20/11";
    static final String[][] infoStr = new String[][]{{"numerator", "String", "Polynomial coefficients or list of polynomials."}, {"denominator", "String", "Polynomial coefficients or list of polynomials."}, {"startFreq", "Real number", "Frequency at left edge of plot."}, {"decades", "Integer", "Number of decades to plot."}, {"units", "String", "Hz or radians."}};
    PlotCanvas theCanvas;
    PolarCanvas thePolar;
    PlotPanel thePanel;
    PlotData theData;
    JTabbedPane thePane;
    String numStr;
    String denStr;
    String startStr;
    String decadesStr;
    String unitsStr;

    void setLAF() {
        String string = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            System.out.println("UnsupportedLookAndFeelException.");
        }
        catch (Exception exception) {
            System.out.println("Failed to set Look And Feel.");
        }
    }

    public BodeNyquist() {
        this.setLAF();
    }

    public BodeNyquist(String[] stringArray) {
        this.numStr = "1,0,1";
        this.denStr = "1,1,1";
        this.startStr = "0.1";
        this.decadesStr = "2";
        this.unitsStr = "radians";
        switch (stringArray.length) {
            case 5: {
                this.unitsStr = stringArray[4];
            }
            case 4: {
                this.decadesStr = stringArray[3];
            }
            case 3: {
                this.startStr = stringArray[2];
            }
            case 2: {
                this.denStr = stringArray[1];
            }
            case 1: {
                this.numStr = stringArray[0];
                break;
            }
            default: {
                System.out.println("usage: java -cp BodeNyquist.jar BodeNyquist numCoeff denCoeff [startFreq [2|3|4 [Hz|rad]]]");
            }
        }
        this.setLAF();
    }

    public static void main(String[] stringArray) {
        BodeNyquist bodeNyquist = new BodeNyquist(stringArray);
        bodeNyquist.init();
        JFrame jFrame = new JFrame("Bode/Nyquist Plot Java Application");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(bodeNyquist);
        ((Component)jFrame).setSize(755, 580);
        ((Component)jFrame).setVisible(true);
        bodeNyquist.start();
    }

    public void init() {
        if (null == this.numStr) {
            this.numStr = this.getParameter("numerator");
        }
        if (null == this.denStr) {
            this.denStr = this.getParameter("denominator");
        }
        if (null == this.startStr) {
            this.startStr = this.getParameter("startFreq");
        }
        if (null == this.decadesStr) {
            this.decadesStr = this.getParameter("decades");
        }
        if (null == this.unitsStr) {
            this.unitsStr = this.getParameter("units");
        }
        System.out.println(versionStr);
        this.getContentPane().setLayout(new FlowLayout(1));
        this.theCanvas = new PlotCanvas(this);
        this.thePolar = new PolarCanvas(this);
        this.thePanel = new PlotPanel(this);
        this.thePane = new JTabbedPane();
        this.thePane.setOpaque(false);
        this.thePane.addTab("Bode Plot", this.theCanvas);
        this.thePane.addTab("Nyquist Plot", this.thePolar);
        this.getContentPane().add(this.thePane);
        this.getContentPane().add(this.thePanel);
    }

    public void start() {
        this.thePanel.doPlot();
    }

    public String getAppletInfo() {
        return versionStr;
    }

    public String[][] getParameterInfo() {
        return infoStr;
    }
}

